/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.parts;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.parts.PanelButton;
import de.willuhn.jameica.gui.parts.TitlePart;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class Panel
implements Part {
    private Part child = null;
    private TitlePart title = null;
    private List<Listener> listeners = new LinkedList<Listener>();
    private PanelButton minimize = null;

    public Panel(String title, Part child) {
        this(title, child, true);
    }

    public Panel(String title, Part child, boolean border) {
        this.title = new TitlePart(title, border);
        this.child = child;
    }

    public void addMinimizeListener(Listener l) {
        if (this.minimize == null) {
            this.minimize = new PanelButton("minimize.png", new Action(){

                @Override
                public void handleAction(Object context) throws ApplicationException {
                    Event e = new Event();
                    e.data = context;
                    for (Listener l : Panel.this.listeners) {
                        l.handleEvent(e);
                    }
                }
            }, Application.getI18n().tr("Minimieren"));
            this.addButton(this.minimize);
        }
        this.listeners.add(l);
    }

    public void addButton(PanelButton b) {
        this.title.addButton(b);
    }

    public void setTitle(String title) {
        this.title.setTitle(title);
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        this.title.paint(parent);
        this.child.paint(this.title.getComposite());
    }
}

